# en0c.gp
set terminal png font VeraBd 18 size 1024,768

set style line  1 lt 1 lw 1.0 lc rgb "#ffffff"
set style line  2 lt 1 lw 1.5 lc rgb "#000000"
set style line  3 lt 1 lw 4.0 lc rgb "#C0C0C0"
set style line  4 lt 1 lw 2.0 lc rgb "#C0C0C0"
set style line  5 lt 1 lw 3.0 lc rgb "#000040"
set style line  6 lt 1 lw 3.0 lc rgb "#8080F0"

unset key
set mxtics 5  
set mytics 5
set grid xtics ytics mxtics mytics ls 3 , ls 4

## taper -------------------------------------

set   xlabel "km   altitude"
set   ylabel "taper"

set   xrange [0:36000]
set   yrange [0:7]
set   output    "taper0cb.png"
plot "en0c.dat"   using   1:2 w li ls 5

set   xrange [0:5000]
set   yrange [0:7]
set   output    "taper0ca.png"
plot "en0c.dat"   using   1:2 w li ls 5

## power from ground ----------------------

set   xlabel "hrs from ground"
set   ylabel "MW   acoustic power"

set key center left
set   xrange  [0:110]
set   yrange  [0:10]
set   output    "power0cb.png"
plot "en0c.dat"   using   6:4 w li ls 5 ti "to vehicle" , \
     ""           using   6:7 w li ls 6 ti "above vehicle"

set key top right
set   xrange  [0:13]
set   yrange  [0:10]
set   output    "power0ca.png"
plot "en0c.dat"   using   6:4 w li ls 5 ti "to vehicle" , \
     ""           using   6:7 w li ls 6 ti "above vehicle"

unset key

## speed ----------------------------------

set   xlabel "hrs from ground"
set   ylabel "m/s  speed"

set   xrange  [0:110]
set   yrange  [0:110]
set   output    "speed0cb.png"
plot "en0c.dat"   using   6:5 w li ls 5

set   xrange  [0:13]
set   yrange  [0:110]
set   output    "speed0ca.png"
plot "en0c.dat"   using   6:5 w li ls 5

## altitude ----------------------------------

set   xlabel "hrs from ground"
set   ylabel "km   altitude"

set   xrange  [0:110]
set   yrange  [0:40000]
set   output    "alt0cb.png"
plot "en0c.dat"   using   6:1 w li ls 5

set   xrange  [0:13]
set   yrange  [0:4000]
set   output    "alt0ca.png"
plot "en0c.dat"   using   6:1 w li ls 5


## power versus gravity ----------------------------------

set key top right
set   xlabel "m/s² gravity"
set   ylabel "MW   acoustic power"

set   xrange  [0:10.0]
set   yrange  [0:20.0]
set   output    "power0cg.png"
plot "en0c.dat"   using   3:4 w li ls 5 ti "to vehicle" , \
     ""           using   3:7 w li ls 6 ti "above vehicle" 
unset key

## gravity -----------------------------------------------

set   xlabel "hrs from ground"
set   ylabel "gravity and rotational\nacceleration, m/s²"

set   xrange  [0:13]
set   yrange  [0:10]
set   output    "grav0ca.png"
plot "en0c.dat"   using   6:3 w li ls 5

set   xrange  [0:110]
set   yrange  [0:10]
set   output    "grav0cb.png"
plot "en0c.dat"   using   6:3 w li ls 5

## gravity divided by taper -------------------------------

set   xlabel "hrs from ground"
set   ylabel "gravity/taper, m/s²"

set   xrange  [0:13]
set   yrange  [0:10]
set   output    "gtap0ca.png"
plot "en0c.dat"   using   6:8 w li ls 5

set   xrange  [0:110]
set   yrange  [0:10]
set   output    "gtap0cb.png"
plot "en0c.dat"   using   6:8 w li ls 5
