# en0cm.gp
set terminal png font VeraBd 18 size 1600,600

set style line  1 lt 1 lw 1.0 lc rgb "#ffffff"
set style line  2 lt 1 lw 1.5 lc rgb "#000000"
set style line  3 lt 1 lw 4.0 lc rgb "#C0C0C0"
set style line  4 lt 1 lw 2.0 lc rgb "#C0C0C0"
set style line  5 lt 1 lw 3.0 lc rgb "#000040"
set style line  6 lt 1 lw 3.0 lc rgb "#8080F0"

unset key
set mxtics 5  
set mytics 5
set grid xtics ytics mxtics mytics ls 3 , ls 4

## taper -------------------------------------

set   output    "taper0cm.png"
set multiplot

unset ylabel
set   xlabel "km   altitude"
set   yrange [0:6.5]

set   format y ""
set   origin 0.0, 0.0
set   size 0.475, 0.95
set   xrange [-100:4900]
unset label 1
plot "en0c.dat"   using   1:2 w li ls 5

set   format y "%2.0f"
set   size   0.58, 0.95
set   origin 0.425, 0.0
set   xrange [-1000:36000]
set   label 1 "Taper       Taper ratio vs. altitude" at graph -0.08, 1.05  front
plot "en0c.dat"   using   1:2 w li ls 5

unset multiplot

## power from ground ----------------------

set   output    "power0cm.png"
set multiplot

unset ylabel
set   xlabel "hrs from ground"
set   yrange  [0:10]

set   format y ""
set   origin 0.00, 0.0
set   size   0.47, 0.95 
set   key top left
unset label 1
set   xrange  [0:13]
plot "en0c.dat"   using   6:4 w li ls 5 ti "to vehicle" , \
     ""           using   6:7 w li ls 6 ti "above vehicle"

unset key
set   format y "%2.0f"
set   label 1 "MW      Acoustic power vs. time" at graph -0.077, 1.05  front
set   size   0.58, 0.95
set   origin 0.43, 0.0
set   xrange  [0:110]
plot "en0c.dat"   using   6:4 w li ls 5 ti "to vehicle" , \
     ""           using   6:7 w li ls 6 ti "above vehicle"

unset label 1
unset multiplot

## speed ----------------------------------

set   output    "speed0cm.png"
set multiplot

set   xlabel "hrs from ground"
unset ylabel
set   yrange  [0:105]
unset key

set   format y ""
set   origin 0.00, 0.0
set   size   0.475, 0.95
set   xrange  [0:13]
unset label 1
plot "en0c.dat"   using   6:5 w li ls 5

unset ylabel
set   format y "%2.0f"
set   size   0.58, 0.95
set   origin 0.43, 0.0
set   xrange  [0:105]
set   label 1 "m/s     Speed vs. time" at graph -0.08, 1.05  front
plot "en0c.dat"   using   6:5 w li ls 5

unset label 1
unset multiplot

## altitude ----------------------------------

set   output    "alt0cm.png"
set multiplot
unset ylabel

set   xlabel "hrs from ground"
unset key

set   origin 0.00, 0.0
set   size   0.46, 0.95
set   xrange  [0:13]
set   yrange  [0:3900]
set   label 1 "km      Altitude vs. time" at graph -0.11, 1.05  front
plot "en0c.dat"   using   6:1 w li ls 5

set   size   0.58, 0.95
set   origin 0.43, 0.0
set   xrange  [0:110]
set   yrange  [0:39000]
plot "en0c.dat"   using   6:1 w li ls 5

unset label 1
unset multiplot

## gravity -----------------------------------------------

set   output    "grav0cm.png"
set   multiplot
unset ylabel

set   format y ""
set   xlabel "hrs from ground"
set   yrange  [0:10.3]
unset key

unset label 1
set   origin 0.00, 0.0
set   size   0.475, 0.95
set   xrange  [0:13]
plot "en0c.dat"   using   6:3 w li ls 5

set   label 1 "m/s²    Gravity and rotational acceleration vs. altitude" at graph -0.08, 1.05  front
set   format y "%2.0f"
set   size   0.58, 0.95
set   origin 0.43, 0.0
set   xrange  [0:110]
plot "en0c.dat"   using   6:3 w li ls 5

unset label 1
unset multiplot

## gravity divided by taper -------------------------------

set   output    "gtap0cm.png"
set   multiplot
unset ylabel

unset label 1
set   yrange  [0:10.2]
set   xlabel "hrs from ground"
unset key

set   format y ""
set   origin 0.00, 0.0
set   size   0.475, 0.95
set   xrange [0:13]
plot "en0c.dat"   using   6:8 w li ls 5

set   label 1 "m/s²    Gravity divided by taper ratio vs. altitude" at graph -0.08, 1.05  front
set   format y "%2.0f"
set   size   0.58, 0.95
set   origin 0.43, 0.0
set   xrange [0:110]
plot "en0c.dat"   using   6:8 w li ls 5

unset multiplot
